using JLD2, Printf, StatsPlots, ArgParse;

include("runit.jl");
include("helpers_experiments.jl");
include("helpers.jl");

function parse_commandline()
    s = ArgParseSettings();

    @add_arg_table! s begin
        "--exp_dir"
            help = "Directory for loading the experiment's data, while saving the plots in the corresponding folder."
            arg_type = String
            default = "experiments/"
        "--format"
            help = "Format to save the figures."
            arg_type = String
            default = "png"
    end

    parse_args(s);
end

parsed_args = parse_commandline();
exp_dir = parsed_args["exp_dir"];
format = parsed_args["format"];

experiments = filter(x -> isdir("$(exp_dir)$x") && occursin("_random_", x), readdir(exp_dir));
for experiment in experiments
    # Check for existing plots in the corresponding format
    existing_plots = length(filter(x -> occursin(".$format", x), readdir("$(exp_dir)$(experiment)/"))) != 0;

    if ! existing_plots
        println("Creating plots in .$format based on $(exp_dir)$(experiment) ...");

        name_experiment = split(experiment, ":")[2];
        @load "$(exp_dir)$(experiment)/$(name_experiment).dat" iss data iss_index δs param_inst Nruns seed;

        # Plot the sample complexity per learner in a boxplot fashion
        delta = split(string(δs[1]), ".")[2];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_$(name_experiment)_delta$(delta).$format";
        plot_rand_samp(iss, data, iss_index, Nruns, file_plot_samp);
    else
        println("Plots in .$format based on $(exp_dir)$(experiment) already exist.");
    end
    println("");
end
